/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.LibraryManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class PHPLibrary
implements IPHPLibrary {
    private final IConfigurationElement element;

    public PHPLibrary(IConfigurationElement element) {
        this.element = element;
    }

    public File getPath() {
        String attribute = this.element.getAttribute("path");
        String namespaceIdentifier = this.element.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)namespaceIdentifier);
        if (bundle != null) {
            File bundleFile;
            try {
                bundleFile = FileLocator.getBundleFile((Bundle)bundle);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error locating the bundle file for a PHP library", (Throwable)e);
                return null;
            }
            return new File(bundleFile, attribute);
        }
        return null;
    }

    @Override
    public boolean isTurnedOn() {
        return LibraryManager.getInstance().isTurnedOn(this);
    }

    @Override
    public String getName() {
        return String.valueOf(this.element.getAttribute("name")) + "(built-in)";
    }

    public URL getIcon() {
        String namespaceIdentifier = this.element.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)namespaceIdentifier);
        return bundle.getResource(this.element.getAttribute("icon"));
    }

    @Override
    public List<String> getDirectories() {
        return Collections.singletonList(this.getPath().getAbsolutePath());
    }

    @Override
    public String getId() {
        return this.element.getAttribute("id");
    }
}

